import FrontCalculatorSymbolFunctionAbstract from "../abstract/front.calculator.symbol.function.abstract";

/**
 * Math.min() function. Expects at least one parameter.
 * Example: "min(1,2,3)" => 1, "min(1,-1)" => -1, "min(0,0)" => 0, "min(2)" => 2
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/min
 */
export default class FrontCalculatorSymbolFunctionMin extends FrontCalculatorSymbolFunctionAbstract {
	constructor() {
		super();

		this.identifiers = ['min'];

	}

	execute(params) {
		if (params.length < 1) {
			throw ('Error: Expected at least one argument, got ' + params.length);
		}

		return Math.min(...params);

	}
}
