package main

import (
	"fmt"
	"log"
	"time"

	"gopkg.in/telebot.v3"
)

func SetupTelegramBot() *telebot.Bot {
	pref := telebot.Settings{
		Token:  TelegramBotToken,
		Poller: &telebot.LongPoller{Timeout: 10 * time.Second},
	}

	bot, err := telebot.NewBot(pref)
	if err != nil {
		log.Fatal("Telegram Bot Error:", err)
	}
	return bot
}

func NotifyTelegram(bot *telebot.Bot, marketCap, price, bundledWallets, topHolders, rugPullRisk, tokenName, tokenSymbol, tokenAddress string) {
	msg := fmt.Sprintf(
        "🔸 Token Name: %s (%s)\n🔸 Token Address: %s\n🔸 Market Cap: %s\n🔸 Price: %s\n🔸 Wallets Bundled: %s\n🔸 Top Holders:\n%s🔸 Rug Pull Risk: %s\n🔸 Tokens Sold: %s",
        tokenName, tokenSymbol, tokenAddress, marketCap, price, bundledWallets, topHolders, rugPullRisk, tokensSold,
    )

	chat := &telebot.Chat{ID: int64(TelegramChatID)} // Convert TelegramChatID to int64
	_, err := bot.Send(chat, msg, telebot.ModeMarkdown)
	if err != nil {
		log.Println("Error sending message to Telegram:", err)
	}
}
