<?php
class ScalabilityProImageSizeManager {
    public function __construct() {
        $unregister_sizes = true;

        if( isset( $_GET['page'] ) ){
            if( $_GET['page'] == 'scalabilitypro' ){
                $unregister_sizes = false;
            }
        }

        if( $unregister_sizes ){
            add_action( 'init', array( $this, 'deregister_image_sizes' ) );   
        }
        
    }

    public function deregister_image_sizes() {
        // Assuming $image_sizes_to_keep is an array of image size names you want to keep.
        // You could retrieve this array from your plugin's configuration, for example:
        $image_sizes_to_keep =  array('thumbnail', 'medium', 'large');

        $options = get_option('wpiperf_settings');

        //$image_sizes_to_keep = ['thumbnail', 'medium', 'large']; // Example sizes to keep
        if( isset( $options['image_sizes']['global'] ) ){
            $image_sizes_to_keep = [];
            foreach( $options['image_sizes']['global'] as $size_name => $value ){
                $image_sizes_to_keep[] = $size_name;
            }
        }
      
        // Get all registered image sizes
        global $_wp_additional_image_sizes;
        $registered_sizes = get_intermediate_image_sizes();

        foreach ($registered_sizes as $size) {
            if (in_array($size, $image_sizes_to_keep)) {
                continue; // Skip sizes that we want to keep
            }
       
            // Sizes registered via add_image_size() are stored in $_wp_additional_image_sizes
            if (isset($_wp_additional_image_sizes[$size])) {
                remove_image_size($size); // Deregister size
            }
        }  
 
        
    }
}

// Initialize the class in your plugin file
new ScalabilityProImageSizeManager();